using System;
using System.Collections.Generic;

namespace CloudService
{
    public static class Helper
    {
        private static readonly Random Random = new();

        private static readonly List<Item> Heroes = new()
        {
            new Item {Type = 0,  Level = 4, Count = 1, Name = "Freya" },
            new Item {Type = 0,  Level = 4, Count = 1, Name = "Freya" },
            new Item {Type = 0,  Level = 4, Count = 1, Name = "Kratos" },
            new Item {Type = 0,  Level = 4, Count = 1, Name = "Link" },
            new Item {Type = 0,  Level = 3, Count = 1, Name = "Thorne" },
            new Item {Type = 0,  Level = 5, Count = 1, Name = "Mario" },
            new Item {Type = 0,  Level = 3, Count = 1, Name = "Seraphina" }
        };

        private static readonly List<Item> Props = new()
        {
            new Item {Type = 1, Level = 3, Count = 1, Name = "checken_leg" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "shell" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "pizza" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "map" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "potion" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "potion_red" },
            new Item {Type = 1, Level = 3, Count = 1, Name = "book" }
        };

        private static readonly List<string> Emojis = new() { "😀", "😂", "😎" };

        public static string GetRandomEmoji()
        {
            return Emojis[Random.Next(Emojis.Count)];
        }

        public static int CalcLuckLevel(int points, int counts)
        {
            // 5 levels
            // level 4: 100/10 = 10
            // level 3: 100/30 = 3.3
            // level 2: 100/50 = 2
            // level 1: 100/70 = 1.4
            // level 0

            // default level 2
            if (counts == 0) return 2;
            var luckPt = (double)points / counts;
            return luckPt switch
            {
                >= 11 => 4,
                >= 3.6 => 3,
                >= 2.2 => 2,
                >= 1.5 => 1,
                _ => 0
            };
        }

        public static List<Item> NewDrawPool()
        {
            var pool = new List<Item>(100) {
                // idx:0 hero
                Heroes[Random.Next(Heroes.Count)] };

            // idx:1-5 diamonds
            for (var i = 1; i <= 5; i++)
            {
                pool.Add(new Item { Type = 2, Name = "diamonds", Count = i });
            }

            // idx:6-50 props
            for (var i = 6; i <= 50; i++)
            {
                pool.Add(Props[Random.Next(Props.Count)]);
            }

            // idx:51-99 coins
            for (var i = 51; i <= 99; i++)
            {
                pool.Add(new Item { Type = 2, Name = "coins", Count = Random.Next(1, 10001) });
            }

            // Fisher-Yates
            var n = pool.Count;
            for (var i = 0; i < n; i++)
            {
                var j = Random.Next(i, n);
                (pool[i], pool[j]) = (pool[j], pool[i]);
            }

            return pool;
        }
    }
}