using System.Collections.Generic;
using UnityEngine;

namespace Unity.Func.Sample
{
    [CreateAssetMenu(fileName = "CardData", menuName = "ScriptableObjects/CardConfig")]
    public class CardConfig : ScriptableObject
    {
        public enum Type
        {
            Heroes = 0,
            Inventory = 1,
            Other = 2,
        }

        public enum CardColor
        {
            Blue,
            Brown,
            Green,
            Purple,
            Red,
            Yellow
        }

        [System.Serializable]
        public class Card
        {
            public string slugName;
            public string cardName;
            public Sprite cardSprite;
            public int level;
            public int count;
            public Type type;
            public CardColor color;
        }

        public List<Card> cards;
    }
}