using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.UI;
using TMPro;
using UnityEngine.Events;

namespace Unity.Func.Sample.UI
{
    public class CardItem : MonoBehaviour
    {
        public List<Sprite> slotBackgrounds;
        public Image slotItemBackground;
        public Image item;
        public TextMeshProUGUI itemCount;
        public TextMeshProUGUI cardName;
        public UnityEvent<CardConfig.Card> itemSelect;
        public TextMeshProUGUI level;
        private CardConfig.Card _card;
        public List<GameObject> stars;
        public GameObject heroBackground;

        public List<GameObject> hideItems;
        public GameObject spark;
        public void Init(CardConfig.Card card)
        {
            slotItemBackground.sprite = slotBackgrounds[(int)card.color];
            item.sprite = card.cardSprite;
            if (itemCount)
            {
                itemCount.text = card.count.ToString();
            }

            if (cardName)
            {
                cardName.text = card.cardName;
            }

            if (stars != null && stars.Any())
            {
                var cardCount = card.count;
                if (cardCount < 0) cardCount = 0;
                if (cardCount > stars.Count) cardCount = stars.Count;
                for (var i = 0; i < cardCount; i += 1)
                {
                    stars[i].SetActive(true);
                }
            }

            // 英雄卡片逻辑处理
            if (card.type == CardConfig.Type.Heroes)
            {
                if (spark)
                {
                    spark.SetActive(true);
                }

                if (heroBackground)
                {
                    heroBackground.SetActive(true);
                }

                if (itemCount)
                {
                    itemCount.gameObject.SetActive(false);
                }
            }

            _card = card;
        }

        public void OnItemClick()
        {
            itemSelect.Invoke(_card);
        }
    }
}