using System.Collections.Generic;
using UnityEngine;

namespace Unity.Func.Sample.UI
{
    public class HeroesUIController : MonoBehaviour
    {
        public Transform listContent;
        public GameObject cardItemPrefab;

        public void Init(List<CardConfig.Card> cards)
        {
            DestroyAllChildren(listContent);

            foreach (var card in cards)
            {
                var gameObj = Instantiate(cardItemPrefab, listContent);
                gameObj.GetComponent<CardItem>().Init(card);
            }
        }

        private static void DestroyAllChildren(Transform parent)
        {
            for (var i = 0; i < parent.childCount; i += 1)
            {
                Destroy(parent.GetChild(i).gameObject);
            }
        }

    }
}