using System.Collections;
using UnityEngine;
using TMPro;

namespace Unity.Func.Sample.UI
{
    public class MessageUI : MonoBehaviour
    {
        private const int DefaultWaitSecond = 3;

        private static MessageUI _instance;
        public GameObject messagePanel;
        public TextMeshProUGUI messageText;

        // Start is called before the first frame update
        private void Start()
        {
            if (_instance == null)
            {
                _instance = this;
            }
            else
            {
                Destroy(this);
            }
        }

        private IEnumerator ShowMessageIEnumerator(string message, int waitSeconds = DefaultWaitSecond)
        {
            messageText.text = message;
            messagePanel.SetActive(true);
            if (waitSeconds == 0) yield break;
            yield return new WaitForSeconds(waitSeconds);
            messagePanel.SetActive(false);
        }

        private void ShowMessage(string message, int waitSeconds = DefaultWaitSecond)
        {
            StartCoroutine(ShowMessageIEnumerator(message, waitSeconds));
        }

        public static void Show(string message, int waitSeconds = DefaultWaitSecond)
        {
            if (_instance != null)
            {
                _instance.ShowMessage(message, waitSeconds);
            }
        }
    }
}