# UOS Func Stateless CRUD MongoDB CSharp SDK

## 用法

### 1.安装 UOS Func Stateless CRUD MongoDB CSharp SDK

```bash
dotnet add package UOS.FuncStateless.MongoDB
```

### 2.引用本 SDK 并连接 MongoDB Client

```csharp
// If you do not specify a databaseId, the sdk will automatically search for and connect to an available database.
// 如果没有指定 databaseId 的话，sdk 会自动获取可用的数据库进行连接。
// Please note: if uos is authorized to store your database password in an encrypted form, this SDK will automatically fill in the password, if not authorized, you will need to specify the database password in your code.
// 注意：如果uos被授权以加密形式存储您的数据库密码，本sdk将自动填入密码，如果未被授权，您需要在代码中指定数据库密码。
// Please note: if there are multiple available databases, you must use the databaseId to specify the desired database you wish to connect to.
// 注意：如果有多个可用数据库的话，请在代码中指定要用于连接的数据库的 databaseId
var databaseId = "";
var databasePassword = "";
var conn = await MongoConnectionManager.GetConnection(databaseId, databasePassword);
```

### 3.使用 MongoDB Client 操作数据库

例：

```csharp
try
{
    var conn = await MongoConnectionManager.GetConnection(databaseId, databasePassword);
    var db = conn.GetDatabase("mongo");
    await db.CreateCollectionAsync("myCollection");
    var collection = db.GetCollection<BsonDocument>("myCollection");

    await collection.InsertOneAsync(new BsonDocument("Name", "Jack"));
    var findResult = await collection.Find(new BsonDocument("Name", "Jack"))
        .ToListAsync();
    foreach(var document in findResult)
    {
        Console.WriteLine($"db query documents:{document["Name"]}");
    }
}
catch (Exception e)
{
    Console.Error.WriteLine(e);
}
```

### 4.完整操作示例

```csharp
/*
环境变量(自动生成)：
Environment.GetEnvironmentVariable("UOS_APP_ID") = "8972b2ba-0000-0000-0000-1274083a2c09";
Environment.GetEnvironmentVariable("UOS_APP_SECRET") = "9e131ad6-0000-0000-0000-936df2b1e70a";
Environment.GetEnvironmentVariable("UOS_APP_SERVICE_SECRET") = "f4f57f44-0000-0000-0000-d469d7b45053";
*/
public static async Task Main()
{
    // If you do not specify a databaseId, the sdk will automatically search for and connect to an available database.
    // 如果没有指定 databaseId 的话，sdk 会自动获取可用的数据库进行连接。
    // Please note: if uos is authorized to store your database password in an encrypted form, this SDK will automatically fill in the password, if not authorized, you will need to specify the database password in your code.
    // 注意：如果uos被授权以加密形式存储您的数据库密码，本sdk将自动填入密码，如果未被授权，您需要在代码中指定数据库密码。
    // Please note: if there are multiple available mongo databases, you must use the databaseId to specify the desired database you wish to connect to.
    // 注意：如果有多个可用的 mongo 数据库的话，请在代码中指定要用于连接的数据库的 databaseId。
    var databaseId = "";
    var databasePassword = "";
    try
    {
        var conn =  await MongoConnectionManager.GetConnection(databaseId, databasePassword);
        var db = conn.GetDatabase("mongo");
        await db.CreateCollectionAsync("myCollection");
        var collection = db.GetCollection<BsonDocument>("myCollection");

        await collection.InsertOneAsync(new BsonDocument("Name", "Jack"));
        var findResult = await collection.Find(new BsonDocument("Name", "Jack"))
            .ToListAsync();
        foreach(var document in findResult)
        {
            Console.WriteLine($"db query documents:{document["Name"]}");
        }
    }
    catch (Exception e)
    {
        Console.Error.WriteLine(e);
    }
}
```
