using System.Collections.Generic;
using UnityEngine;
using TMPro;

namespace Unity.Func.Sample.UI
{
    public class InputFieldManager : MonoBehaviour
    {
        [SerializeField] private TMP_InputField usernameInputField;
        [SerializeField] private TMP_InputField passwordInputField;
        private static InputFieldManager _instance;

        public static string Username => _instance.usernameInputField.text;

        public static string Password => _instance.passwordInputField.text;

        public static string GetEmptyItems()
        {
            var emptyItems = new List<string>();

            if (string.IsNullOrEmpty(Username))
            {
                emptyItems.Add("Username");
            }
            if (string.IsNullOrEmpty(Password))
            {
                emptyItems.Add("Password");
            }
            return string.Join("、", emptyItems);
        }

        // Start is called before the first frame update
        private void Start()
        {
            if (_instance == null)
            {
                _instance = this;
            }
        }
    }
}