"use strict";
const { newDrawPool, GetRandomEmoji } = require("../utils/utils");

exports.main = async (event, context) => {
  // parse body -> (username, password)
  const body = JSON.parse(event.body);
  const { username, password } = body;

  // debug log: print request data
  console.log("username: ", username, " ", typeof username);
  console.log("password: ", password, " ", typeof password);

  if (!username || !password) {
    return { msg: "cannot found username or password" };
  }

  context.database = require("func-stateless-mongodb-sdk-nodejs").database;

  // TL;DR
  //   demo game login logic
  try {
    // get db connection
    const database = await context.database();
    const client = await database.connection();

    const db = client.db("stateless-demo");
    const users = db.collection("users");

    const query = { username: username };
    const option = {
      projection: {
        _id: 1,
        nickname: 1,
        password: 1,
        diamonds: 1,
        coins: 1,
        luckPoints: 1,
        drawCounts: 1,
      },
    };
    const user = await users.findOne(query, option);

    // search mongo, found one return nickname, id;
    if (user) {
      if (password !== user.password) {
        return { msg: "username or password is not correct" };
      }

      return {
        id: user._id,
        nickname: user.nickname,
        diamonds: user.diamonds,
        coins: user.coins,
      };
    }

    // not found, initialize an account, and return nickname, id
    // init user info, inventory, pool
    const initInfo = {
      username: username,
      nickname: username + GetRandomEmoji(),
      password: password,
      // diamonds: Math.floor(Math.random() * 1000000)+1
      diamonds: 500,
      // coins: Math.floor(Math.random() * 1000000)+1,
      coins: 0,
      luckPoints: 0,
      drawCounts: 0,
      drawPool: newDrawPool(),
      heros: {},
      props: {},
    };
    const result = await users.insertOne(initInfo);
    if (result.acknowledged !== true || result.insertedId === undefined) {
      throw new Error("fail to create user");
    }

    return {
      id: result.insertedId,
      nickname: initInfo.nickname,
      diamonds: initInfo.diamonds,
      coins: initInfo.coins,
    };
  } catch (e) {
    return { msg: e.message };
  }
};
