const Heros = [
  { name: "Freya", level: 4 },
  { name: "Kratos", level: 4 },
  { name: "Link", level: 4 },
  { name: "Thorne", level: 3 },
  { name: "Mario", level: 5 },
  { name: "Seraphina", level: 3 },
];

const Props = [
  { name: "checken_leg", level: 3 },
  { name: "shell", level: 3 },
  { name: "pizza", level: 3 },
  { name: "map", level: 3 },
  { name: "potion", level: 3 },
  { name: "potion_red", level: 3 },
  { name: "book", level: 3 },
];

const emojis = ["😊", "😁", "😄", "😆"];

exports.GetRandomEmoji = function () {
  return emojis[Math.floor(Math.random() * emojis.length)];
};

exports.calcLuckLevel = function (points, counts) {
  // 5 levels
  // level 4 10抽出 100/10 = 10
  // level 3 30抽出 100/30 = 3.3
  // level 2 50抽出 100/50 = 2
  // level 1 70抽出 100/70 = 1.4
  // level 0 90抽出

  // default level 2
  if (counts === 0) return 2;

  const luckPt = points / counts;

  if (luckPt >= 11) return 4;
  if (luckPt >= 3.6) return 3;
  if (luckPt >= 2.2) return 2;
  if (luckPt >= 1.5) return 1;
  return 0;
};

exports.newDrawPool = function () {
  const pool = [];

  // idx:0 hero
  pool.push({
    ...Heros[Math.floor(Math.random() * Heros.length)],
    type: 0,
    count: 1,
  });

  // idx:1-5 diamonds
  for (let i = 1; i <= 5; i += 1) {
    pool.push({ type: 2, name: "diamonds", count: i });
  }

  // idx: 6-50 props
  for (let i = 6; i <= 50; i += 1) {
    pool.push({
      ...Props[Math.floor(Math.random() * Props.length)],
      type: 1,
      count: 1,
    });
  }

  // idx: 51-99 coins
  for (let i = 51; i <= 99; i += 1) {
    pool.push({
      type: 2,
      name: "coins",
      count: Math.floor(Math.random() * 10000) + 1,
    });
  }

  // shuffle array
  for (let i = pool.length - 1; i > 0; i -= 1) {
    const j = Math.floor(Math.random() * (i + 1));
    [pool[i], pool[j]] = [pool[j], pool[i]];
  }

  return pool;
};
