'use strict';

const xid = require('xid-js');
const axios = require('axios');
const {wxAppId, mchId, pay, notifyUrl, formatAndValidateExpiredAt} = require("../utils/common");

exports.main = async function (event, context) {
    const req = JSON.parse(event.body);
    const {totalAmount, subject, clientIP, productSlug, personaId, expiredAt} = req;

    console.log('totalAmount:', totalAmount);
    console.log('subject:', subject);
    console.log('clientIP:', clientIP);
    console.log('productSlug:', productSlug);
    console.log('personaId:', personaId);

    const outTradeNo = xid.next();
    console.log('outTradeNo:', outTradeNo);

    const result = formatAndValidateExpiredAt(expiredAt);
    if (result.error) {
        return result.error;
    }

    const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

    const requestData = {
        // appid: wxAppId,
        // mchid:  mchId,
        description: subject,
        out_trade_no: outTradeNo,
        notify_url: notifyUrl,
        amount: {
            total: totalAmount,
        },
        scene_info: {
            payer_client_ip: clientIP,
            h5_info: {
                type: 'Wap',
            },
        },
    }
    if (result.formattedDate !== null) {
        requestData.time_expire = result.formattedDate;
    }

    const wechatResult = await pay.transactions_h5(requestData);
    console.log('wechat result:', wechatResult);

    if (wechatResult.status !== 200) {
        return {
            statusCode: 400,
            headers: {"Content-Type": "application/json"},
            body: wechatResult.error,
        };
    }

    try {
        const uosResp = await axios.post('https://p.unity.cn/v1/payments', {
            personaId: personaId,
            outTradeNo: outTradeNo,
            paymentMethod: "wxpay.MWEB",
            totalAmount: totalAmount,
            productSlug: productSlug,
            expiredAt: expiredAt
        }, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
            }
        });
        console.log('uos result:', uosResp.body)
    } catch (error) {
        console.log(error);
        return {
            statusCode: 400,
        };
    }

    // h5_url为拉起微信支付收银台的中间页面，可通过访问该URL来拉起微信客户端，完成支付，h5_url的有效期为5分钟。
    // example:
    // {
    //     "h5_url" : "https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx2016121516420242444321ca0631331346&package=1405458241"
    // }
    return wechatResult;
};