'use strict';

const xid = require('xid-js');
const axios = require('axios');
const {wxAppId, mchId, pay, notifyUrl, formatAndValidateExpiredAt} = require("../utils/common");

exports.main = async function (event, context) {
    const req = JSON.parse(event.body);
    const {totalAmount, subject, productSlug, personaId, openid, expiredAt} = req;

    console.log('totalAmount:', totalAmount);
    console.log('subject:', subject);
    console.log('productSlug:', productSlug);
    console.log('personaId:', personaId);
    console.log('openid:', openid);

    const outTradeNo = xid.next();
    console.log('outTradeNo:', outTradeNo);

    const result = formatAndValidateExpiredAt(expiredAt);
    if (result.error) {
        return result.error;
    }

    const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

    const requestData = {
        // appid: wxAppId,
        // mchid:  mchId,
        description: subject,
        out_trade_no: outTradeNo,
        notify_url: notifyUrl,
        amount: {
            total: totalAmount,
        },
        payer: {
            openid: openid
        }
    }

    if (result.formattedDate !== null) {
        requestData.time_expire = result.formattedDate;
    }
    const wechatResult = await pay.transactions_jsapi(requestData);
    console.log('wechat result:', wechatResult);

    if (wechatResult.status !== 200) {
        return {
            statusCode: 400,
            headers: {"Content-Type": "application/json"},
            body: wechatResult.error,
        };
    }

    try {
        const uosResp = await axios.post('https://p.unity.cn/v1/payments', {
            personaId: personaId,
            outTradeNo: outTradeNo,
            paymentMethod: "wxpay.JSAPI",
            totalAmount: totalAmount,
            productSlug: productSlug,
            expiredAt: expiredAt
        }, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
            }
        });
        console.log('uos result:', uosResp.body)
    } catch (error) {
        console.log(error);
        return {
            statusCode: 400,
            headers: {"Content-Type": "application/json"},
            body: JSON.stringify(error.response.data),
        };
    }

    // prepay_id: 预支付交易会话标识。用于后续接口调用中使用，该值有效期为2小时
    // example:
    // {
    //   "prepay_id" : "wx201410272009395522657a690389285100"
    // }
    return wechatResult;
};