'use strict';

const xid = require('xid-js');
const axios = require('axios');
const {pay, notifyUrl, formatAndValidateExpiredAt} = require("../utils/common");

exports.main = async function (event, context) {
    const req = JSON.parse(event.body);
    const {totalAmount, subject, productSlug, personaId, expiredAt} = req;

    console.log('totalAmount:', totalAmount);
    console.log('subject:', subject);
    console.log('productSlug:', productSlug);
    console.log('personaId:', personaId);

    const outTradeNo = xid.next();
    console.log('outTradeNo:', outTradeNo);

    const result = formatAndValidateExpiredAt(expiredAt);
    if (result.error) {
        return result.error;
    }

    const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

    const requestData = {
        description: subject,
        out_trade_no: outTradeNo,
        notify_url: notifyUrl,
        amount: {
            total: totalAmount,
        },
    };
    if (result.formattedDate !== null) {
        requestData.time_expire = result.formattedDate;
    }
    const wechatResult = await pay.transactions_native(requestData)
    console.log('wechat result:', wechatResult);

    if (wechatResult.status !== 200) {
        return {
            statusCode: 400,
            headers: {"Content-Type": "application/json"},
            body: wechatResult.error,
        };
    }

    try {
        const uosResp = await axios.post('https://p.unity.cn/v1/payments', {
            personaId: personaId,
            outTradeNo: outTradeNo,
            paymentMethod: "wxpay.Native",
            totalAmount: totalAmount,
            productSlug: productSlug,
            expiredAt: expiredAt
        }, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
            }
        });

        console.log('uos result:', uosResp.body)
    } catch (err) {
        console.error(err);
        return {
            statusCode: 400,
            headers: {"Content-Type": "application/json"},
            body: JSON.stringify(err.response.data),
        };
    }

    // 此URL用于生成支付二维码，然后提供给用户扫码支付。code_url并非固定值，使用时按照URL格式转成二维码即可。
    // example:
    // {
    //   "code_url" : "weixin://wxpay/bizpayurl/up?pr=NwY5Mz9&groupid=00"
    // }
    return wechatResult;
};