'use strict';

const WxPay = require('wechatpay-node-v3');
const fs = require('fs');
const moment = require("moment-timezone");

// 直连商户申请的公众号或移动应用appid
const appId = "";
// 用商户平台上设置的APIv3密钥【微信商户平台 (opens new window)—>账户设置—>API安全—>设置APIv3密钥】，记为key
const apiKey = "";
// 商户号
const mchId = "";

exports.wxAppId = appId;
exports.apiV3Key = apiKey;
exports.pay = new WxPay({
    appid: appId,
    mchid: mchId,
    publicKey: fs.readFileSync('./apiclient_cert.pem'), // 公钥
    privateKey: fs.readFileSync('./apiclient_key.pem'), // 秘钥
});

// 异步回调地址
exports.notifyUrl = "";
exports.formatAndValidateExpiredAt = function(expiredAt) {
    let result = {
        formattedDate: null,
        error: null
    };
    if (expiredAt !== undefined) {
        let date = new Date(expiredAt);
        if(date.toString() === 'Invalid Date') {
            console.log('Variable expiredAt is not a valid time:', expiredAt);
            result.error = {
                statusCode: 400,
                headers: {"Content-Type":"application/json"},
                body: "invalid expiredAt. not a valid time.",
            };
            return result
        }
        if (date.getTime() <= Date.now()) {
            console.log('Variable expiredAt should after now time:', expiredAt);
            result.error = {
                statusCode: 400,
                headers: {"Content-Type":"application/json"},
                body: "invalid expiredAt. should after now time.",
            };
            return result
        }

        result.formattedDate = moment.utc(date).format('YYYY-MM-DDTHH:mm:ssZ')
        console.log('converted expiredAt:', result.formattedDate);
    }
    return result;
}


