'use strict';

const axios = require('axios');
const { wxAppId, apiV3Key, pay} = require("../utils/common");

exports.main = async function (event, context) {
  const req = JSON.parse(event.body);
  console.log("notify:", req);

  const resource = pay.decipher_gcm(req?.resource?.ciphertext, req?.resource?.associated_data, req?.resource?.nonce, apiV3Key);
  console.log('resource:', resource);

  const {appid, out_trade_no, trade_state, amount} = resource;

  console.log('App id:', JSON.stringify(appid));
  console.log('outTradeNo:', JSON.stringify(out_trade_no));
  console.log('Trade status:', JSON.stringify(trade_state));

  if (appid !== wxAppId) {
    return {
      statusCode: 400,
      headers: {"Content-Type":"text/html"},
      body: "inconsistent app id",
    };
  }

  let paymentSuccess = false
  if (trade_state === "SUCCESS") {
    paymentSuccess = true
  }

  const {appId, appSecret} = process.env;

  try {
    const response = await axios.post('https://p.unity.cn/v1/payments/notify', {
      outTradeNo: out_trade_no,
      tradeState: trade_state,
      totalAmount: amount?.total,
      paymentSuccess: paymentSuccess
    }, {
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Basic ' + btoa(appId + ':' + appSecret)
      }
    });

  } catch (err) {
    console.error(err);
    return {
      statusCode: 400,
      headers: {"Content-Type":"application/json"},
      body: err.response.data,
    };
  }

  return {
    statusCode: 200,
    headers: {"Content-Type":"application/json"},
    body: JSON.stringify({
      code: "SUCCESS",
    }),
  };
};

